#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI.controls;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmUnitDataReport
	/// </summary>
	public class FrmUnitDataReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Controls

        private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.GroupBox grpImage1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Variables

		private const string _reportTitle = "Blood Unit History Report";

		private BloodUnitReport _bloodUnitReport;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvBloodUnitHistoryReport;

		//private BloodUnitHistoryReport  _bloodUnitHistoryReport;
		private Guid					_bloodUnitGuid;
        private DataSet _reportData;
	
		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmUnitDataReport));
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.grpImage1 = new System.Windows.Forms.GroupBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.rvBloodUnitHistoryReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Unit History Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.Location = new System.Drawing.Point(564, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // grpImage1
            // 
            this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage1.Controls.Add(this.pictureBox2);
            this.grpImage1.Location = new System.Drawing.Point(4, 32);
            this.grpImage1.Name = "grpImage1";
            this.grpImage1.Size = new System.Drawing.Size(52, 412);
            this.grpImage1.TabIndex = 4;
            this.grpImage1.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 12);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(45, 45);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Location = new System.Drawing.Point(0, 0);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(100, 50);
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // rvBloodUnitHistoryReport
            // 
            this.rvBloodUnitHistoryReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvBloodUnitHistoryReport.Location = new System.Drawing.Point(60, 37);
            this.rvBloodUnitHistoryReport.Name = "rvBloodUnitHistoryReport";
            this.rvBloodUnitHistoryReport.Size = new System.Drawing.Size(579, 405);
            this.rvBloodUnitHistoryReport.TabIndex = 6;
            // 
            // FrmUnitDataReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnPrint;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvBloodUnitHistoryReport);
            this.Controls.Add(this.grpImage1);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.btnCancel);
            this.hlphelpChm.SetHelpKeyword(this, "Unit_History_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmUnitDataReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Unit History Report";
            this.Load += new System.EventHandler(this.FrmUnitDataReport_Load);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage1, 0);
            this.Controls.SetChildIndex(this.rvBloodUnitHistoryReport, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage1.ResumeLayout(false);
            this.grpImage1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Properties

		/// <summary>
		/// BloodUnitGuid
		/// </summary>
		private Guid BloodUnitGuid
		{
			get 
			{
				return _bloodUnitGuid;
			}
			set
			{
				_bloodUnitGuid = value;
			}
		}

		#endregion

		#region Constructors / Destructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmUnitDataReport(BloodUnitReport bloodUnitReport)
		{
			InitializeComponent();
			SetComponentProperties();

			this._bloodUnitReport = bloodUnitReport;

			SetUpReport();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Methods

		/// <summary>
		/// SetUpReport
		/// </summary>
		private void SetUpReport()
		{ 

			_reportData = this._bloodUnitReport.GetReportTables();

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._bloodUnitReport.GetReportCriteria());

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.BloodUnitHistorySummary].Rows.Count > 0)
            {
                reportSourceMain.Name = "BloodUnitHistoryDataSet";
                reportSourceMain.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.BloodUnitHistorySummary];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }
            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitHistoryReportMain.rdlc");
            Stream streamIncomingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitIncomingShipmentHistory.rdlc");
            Stream streamOutgoingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitOutgoingShipmentHistory.rdlc");
            Stream streamAntigenTyping = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitAntigenTypingHistory.rdlc");
            Stream streamRestrictedPatient = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitRestrictedPatientHistory.rdlc");
            Stream streamStatus = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitStatusHistory.rdlc");
            Stream streamFinance = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitFinancialHistory.rdlc");
            Stream streamPatientAssociation = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitPatientAssociationHistory.rdlc");
            Stream streamIssue = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitIssueHistory.rdlc");
            Stream streamTesting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitTestingHistory.rdlc");
            Stream streamCrossmatch = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitCrossmatchTestingHistory.rdlc");
            Stream streamModificationOriginalUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationOriginalUnitsHistory.rdlc");
            Stream streamModificationTargetUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationTargetUnitsHistory.rdlc");
            Stream streamModification = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationHistory.rdlc");
            Stream streamModificationEquipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationEquipmentHistory.rdlc");
            Stream streamTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitTransfusionHistory.rdlc");
            Stream streamExceptionAntigenTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionAntigenTest.rdlc");
            Stream streamExceptionExpiredUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionExpiredUnit.rdlc");
            Stream streamExceptionLabelMismatch = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionLabelMismatch.rdlc");
            Stream streamExceptionQuarantine = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQuarantine.rdlc");
            Stream streamExceptionRemoveFinalUnitStatus = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionRemoveFinalUnitStatus.rdlc");
            Stream streamExceptionReturnIssuedUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReturnIssuedUnit.rdlc");
            Stream streamExceptionUnitAboRh = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitAboRh.rdlc");
            Stream streamExceptionUnitModification = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitModification.rdlc");
            Stream streamExceptionUnitSelection = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSelection.rdlc");
            Stream streamExceptionUnitSupply = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSupply.rdlc");
            Stream streamExceptionQC = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQC.rdlc");

            this.rvBloodUnitHistoryReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);
                 
            this.rvBloodUnitHistoryReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvBloodUnitHistoryReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvBloodUnitHistoryReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvBloodUnitHistoryReport.LocalReport.LoadReportDefinition(stream);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitIncomingShipmentHistory", streamIncomingShipment);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitOutgoingShipmentHistory", streamOutgoingShipment);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitAntigenTypingHistory", streamAntigenTyping);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitRestrictedPatientHistory", streamRestrictedPatient);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitStatusHistory", streamStatus);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitFinancialHistory", streamFinance);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitPatientAssociationHistory", streamPatientAssociation);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitIssueHistory", streamIssue);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitTestingHistory", streamTesting);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitCrossmatchTestingHistory", streamCrossmatch);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitModificationOriginalUnitsHistory", streamModificationOriginalUnits);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitModificationTargetUnitsHistory", streamModificationTargetUnits);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitModificationHistory", streamModification);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitModificationEquipmentHistory", streamModificationEquipment);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("BloodUnitTransfusionHistory", streamTransfusion);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionAntigenTest", streamExceptionAntigenTest);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionExpiredUnit", streamExceptionExpiredUnit);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionLabelMismatch", streamExceptionLabelMismatch);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionQuarantine", streamExceptionQuarantine);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionRemoveFinalUnitStatus", streamExceptionRemoveFinalUnitStatus);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionReturnIssuedUnit", streamExceptionReturnIssuedUnit);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitAboRh", streamExceptionUnitAboRh);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitModification", streamExceptionUnitModification);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitSelection", streamExceptionUnitSelection);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitSupply", streamExceptionUnitSupply);
            this.rvBloodUnitHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionQC", streamExceptionQC);

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IncomingShipmentReport) < 0 ||
                this._bloodUnitReport.IncludeIncomingShipmentReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideIncomingShipment", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideIncomingShipment", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OutgoingShipmentReport) < 0 ||
                this._bloodUnitReport.IncludeOutgoingShipmentReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideOutgoingShipment", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideOutgoingShipment", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.AntigenTypingReport) < 0 ||
              this._bloodUnitReport.IncludeAntigenTypingReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideAntigenTyping", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideAntigenTyping", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.DirectedPatientReport) < 0 ||
                this._bloodUnitReport.IncludeRestrictedPatientReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideRestrictedPatient", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideRestrictedPatient", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.StatusReport) < 0 ||
               this._bloodUnitReport.IncludeStatusReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideStatus", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideStatus", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.FinanceReport) < 0 ||
               this._bloodUnitReport.IncludeFinanceReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideFinance", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideFinance", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.PatientAssociationReport) < 0 ||
               this._bloodUnitReport.IncludePatientAssociationReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HidePatientAssociation", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HidePatientAssociation", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IssueReport) < 0 ||
               this._bloodUnitReport.IncludeIssueReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideIssue", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideIssue", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.BloodUnitTestingReport) < 0 ||
              this._bloodUnitReport.IncludeBloodUnitTestingReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideTesting", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideTesting", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.CrossmatchTestingReport) < 0 ||
              this._bloodUnitReport.IncludeCrossmatchTestingReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideCrossmatch", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideCrossmatch", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OriginalUnitsFromModification) < 0 ||
             this._bloodUnitReport.IncludeModificationReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideOriginalUnits", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideOriginalUnits", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TargetUnitsFromModification) < 0 ||
             this._bloodUnitReport.IncludeModificationReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideTargetUnits", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideTargetUnits", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationReport) < 0 ||
            this._bloodUnitReport.IncludeModificationReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideModification", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideModification", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationEquipmentAndSupplies) < 0 ||
           this._bloodUnitReport.IncludeModificationReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideEquipment", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideEquipment", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TransfusionReport) < 0 ||
                this._bloodUnitReport.IncludeTransfusionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideTransfusion", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideTransfusion", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionAntigenTest") < 0 ||
               this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionAntigenTest", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionAntigenTest", "false"));

            if (this._reportData.Tables.IndexOf("GetExceptionReportExpiredUnitReceived") < 0 ||
               this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionExpiredUnit", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionExpiredUnit", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportLabelMismatch") < 0 ||
               this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionLabelMismatch", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionLabelMismatch", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportQuarantine") < 0 ||
               this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionQuarantine", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionQuarantine", "false"));

            if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString()) < 0 ||
               this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionRemoveFinalUnitStatus", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionRemoveFinalUnitStatus", "false"));

            if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()) < 0 ||
              this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionReturnIssuedUnit", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionReturnIssuedUnit", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitAboRh") < 0 ||
             this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitAboRh", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitAboRh", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitModification") < 0 ||
            this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitModification", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitModification", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitSelection") < 0 ||
            this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitSelection", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitSelection", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitSupplyForBloodUnit") < 0 ||
            this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitSupply", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionUnitSupply", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportQC") < 0 ||
            this._bloodUnitReport.IncludeExceptionReport == false)
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionQC", "true"));
            else
                this.rvBloodUnitHistoryReport.LocalReport.SetParameters(new ReportParameter("HideExceptionQC", "false"));

            this.rvBloodUnitHistoryReport.RefreshReport();

		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "BloodUnitIncomingShipmentHistory" || e.DataSourceNames[0].ToString() == "BloodUnitIncomingShipmentDataSet")
            {
                ReportDataSource reportSourceIncomingShipment = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IncomingShipmentReport) >= 0)
                {
                    reportSourceIncomingShipment.Name = "BloodUnitIncomingShipmentDataSet";
                    reportSourceIncomingShipment.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.IncomingShipmentReport];
                }
                e.DataSources.Add(reportSourceIncomingShipment);
            }
            else if (e.ReportPath == "BloodUnitOutgoingShipmentHistory" || e.DataSourceNames[0].ToString() == "BloodUnitOutgoingShipmentDataSet")
            {
                ReportDataSource reportSourceOutgoingShipment = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OutgoingShipmentReport) >= 0)
                {
                    reportSourceOutgoingShipment.Name = "BloodUnitOutgoingShipmentDataSet";
                    reportSourceOutgoingShipment.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.OutgoingShipmentReport];
                }
                e.DataSources.Add(reportSourceOutgoingShipment);
            }
            else if (e.ReportPath == "BloodUnitAntigenTypingHistory" || e.DataSourceNames[0].ToString() == "BloodUnitAntigenTypingDataSet")
            {
                ReportDataSource reportSourceAntigenTyping = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.AntigenTypingReport) >= 0)
                {
                    reportSourceAntigenTyping.Name = "BloodUnitAntigenTypingDataSet";
                    reportSourceAntigenTyping.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.AntigenTypingReport];
                }
                e.DataSources.Add(reportSourceAntigenTyping);
            }
            else if (e.ReportPath == "BloodUnitRestrictedPatientHistory" || e.DataSourceNames[0].ToString() == "BloodUnitRestrictedPatientDataSet")
            {
                ReportDataSource reportSourceRestrictedPatient = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.DirectedPatientReport) >= 0)
                {
                    reportSourceRestrictedPatient.Name = "BloodUnitRestrictedPatientDataSet";
                    reportSourceRestrictedPatient.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.DirectedPatientReport];
                }
                e.DataSources.Add(reportSourceRestrictedPatient);
            }
            else if (e.ReportPath == "BloodUnitStatusHistory" || e.DataSourceNames[0].ToString() == "BloodUnitStatusDataSet")
            {
                ReportDataSource reportSourceStatus = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.StatusReport) >= 0)
                {
                    reportSourceStatus.Name = "BloodUnitStatusDataSet";
                    reportSourceStatus.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.StatusReport];
                }
                e.DataSources.Add(reportSourceStatus);
            }
            else if (e.ReportPath == "BloodUnitFinancialHistory" || e.DataSourceNames[0].ToString() == "BloodUnitFinancialDataSet")
            {
                ReportDataSource reportSourceFinance = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.FinanceReport) >= 0)
                {
                    reportSourceFinance.Name = "BloodUnitFinancialDataSet";
                    reportSourceFinance.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.FinanceReport];
                }
                e.DataSources.Add(reportSourceFinance);
            }
            else if (e.ReportPath == "BloodUnitPatientAssociationHistory" || e.DataSourceNames[0].ToString() == "BloodUnitPatientAssociationDataSet")
            {
                ReportDataSource reportSourcePatientAssociation = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.PatientAssociationReport) >= 0)
                {
                    reportSourcePatientAssociation.Name = "BloodUnitPatientAssociationDataSet";
                    reportSourcePatientAssociation.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.PatientAssociationReport];
                }
                e.DataSources.Add(reportSourcePatientAssociation);
            }
            else if (e.ReportPath == "BloodUnitIssueHistory" || e.DataSourceNames[0].ToString() == "BloodUnitIssueDataSet")
            {
                ReportDataSource reportSourceIssue = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IssueReport) >= 0)
                {
                    reportSourceIssue.Name = "BloodUnitIssueDataSet";
                    reportSourceIssue.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.IssueReport];
                }
                e.DataSources.Add(reportSourceIssue);
            }
            else if (e.ReportPath == "BloodUnitTestingHistory" || e.DataSourceNames[0].ToString() == "BloodUnitTestingDataSet")
            {
                ReportDataSource reportSourceTesting = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.BloodUnitTestingReport) >= 0)
                {
                    reportSourceTesting.Name = "BloodUnitTestingDataSet";
                    reportSourceTesting.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.BloodUnitTestingReport];
                }
                e.DataSources.Add(reportSourceTesting);
            }
            else if (e.ReportPath == "BloodUnitCrossmatchTestingHistory" || e.DataSourceNames[0].ToString() == "BloodUnitCrossmatchTestingDataSet")
            {
                ReportDataSource reportSourceCrossmatchTesting = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.CrossmatchTestingReport) >= 0)
                {
                    reportSourceCrossmatchTesting.Name = "BloodUnitCrossmatchTestingDataSet";
                    reportSourceCrossmatchTesting.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.CrossmatchTestingReport];
                }
                e.DataSources.Add(reportSourceCrossmatchTesting);
            }
            else if (e.ReportPath == "BloodUnitModificationOriginalUnitsHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationOriginalUnitsDataSet")
            {
                ReportDataSource reportSourceOriginalUnits = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OriginalUnitsFromModification) >= 0)
                {
                    reportSourceOriginalUnits.Name = "BloodUnitModificationOriginalUnitsDataSet";
                    reportSourceOriginalUnits.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.OriginalUnitsFromModification];
                }
                e.DataSources.Add(reportSourceOriginalUnits);
            }
            else if (e.ReportPath == "BloodUnitModificationTargetUnitsHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationTargetUnitsDataSet")
            {
                ReportDataSource reportSourceTargetUnits = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TargetUnitsFromModification) >= 0)
                {
                    reportSourceTargetUnits.Name = "BloodUnitModificationTargetUnitsDataSet";
                    reportSourceTargetUnits.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.TargetUnitsFromModification];
                }
                e.DataSources.Add(reportSourceTargetUnits);
            }
            else if (e.ReportPath == "BloodUnitModificationHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationDataSet")
            {
                ReportDataSource reportSourceModification = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationReport) >= 0)
                {
                    reportSourceModification.Name = "BloodUnitModificationDataSet";
                    reportSourceModification.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.ModificationReport];
                }
                e.DataSources.Add(reportSourceModification);
            }
            else if (e.ReportPath == "BloodUnitModificationEquipmentHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationEquipmentDataSet")
            {
                ReportDataSource reportSourceModificationEquipment = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationEquipmentAndSupplies) >= 0)
                {
                    reportSourceModificationEquipment.Name = "BloodUnitModificationEquipmentDataSet";
                    reportSourceModificationEquipment.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.ModificationEquipmentAndSupplies];
                }
                e.DataSources.Add(reportSourceModificationEquipment);
            }
            else if (e.ReportPath == "BloodUnitTransfusionHistory" || e.DataSourceNames[0].ToString() == "BloodUnitTransfusionDataSet")
            {
                ReportDataSource reportSourceTransfusion = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TransfusionReport) >= 0)
                {
                    reportSourceTransfusion.Name = "BloodUnitTransfusionDataSet";
                    reportSourceTransfusion.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.TransfusionReport];
                }
                e.DataSources.Add(reportSourceTransfusion);
            }
            else if (e.ReportPath == "ExceptionAntigenTest" || e.DataSourceNames[0].ToString() == "ExceptionAntigenTestDataSet")
            {
                ReportDataSource reportSourceExceptionAntigenTest = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionAntigenTest") >= 0)
                {
                    reportSourceExceptionAntigenTest.Name = "ExceptionAntigenTestDataSet";
                    reportSourceExceptionAntigenTest.Value = _reportData.Tables["ExceptionAntigenTest"];
                }
                e.DataSources.Add(reportSourceExceptionAntigenTest);
            }
            else if (e.ReportPath == "ExceptionExpiredUnit" || e.DataSourceNames[0].ToString() == "ExceptionExpiredUnitDataSet")
            {
                ReportDataSource reportSourceExceptionExpiredUnit = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("GetExceptionReportExpiredUnitReceived") >= 0)
                {
                    reportSourceExceptionExpiredUnit.Name = "ExceptionExpiredUnitDataSet";
                    reportSourceExceptionExpiredUnit.Value = _reportData.Tables["GetExceptionReportExpiredUnitReceived"];
                }
                e.DataSources.Add(reportSourceExceptionExpiredUnit);
            }
            else if (e.ReportPath == "ExceptionLabelMismatch" || e.DataSourceNames[0].ToString() == "ExceptionLabelMismatchDataSet")
            {
                ReportDataSource reportSourceExceptionLabelMismatch = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportLabelMismatch") >= 0)
                {
                    reportSourceExceptionLabelMismatch.Name = "ExceptionLabelMismatchDataSet";
                    reportSourceExceptionLabelMismatch.Value = _reportData.Tables["ExceptionReportLabelMismatch"];
                }
                e.DataSources.Add(reportSourceExceptionLabelMismatch);
            }
            else if (e.ReportPath == "ExceptionQuarantine" || e.DataSourceNames[0].ToString() == "ExceptionQuarantineDataSet")
            {
                ReportDataSource reportSourceExceptionQuarantine = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportQuarantine") >= 0)
                {
                    reportSourceExceptionQuarantine.Name = "ExceptionQuarantineDataSet";
                    reportSourceExceptionQuarantine.Value = _reportData.Tables["ExceptionReportQuarantine"];
                }
                e.DataSources.Add(reportSourceExceptionQuarantine);
            }
            else if (e.ReportPath == "ExceptionRemoveFinalUnitStatus" || e.DataSourceNames[0].ToString() == "ExceptionRemoveFinalUnitStatusDataSet")
            {
                ReportDataSource reportSourceExceptionRemoveFinalUnitStatus = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString()) >= 0)
                {
                    reportSourceExceptionRemoveFinalUnitStatus.Name = "ExceptionRemoveFinalUnitStatusDataSet";
                    reportSourceExceptionRemoveFinalUnitStatus.Value = _reportData.Tables[Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionRemoveFinalUnitStatus);
            }
            else if (e.ReportPath == "ExceptionReturnIssuedUnit" || e.DataSourceNames[0].ToString() == "ExceptionReturnIssuedUnitDataSet")
            {
                ReportDataSource reportSourceExceptionReturnIssuedUnit = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()) >= 0)
                {
                    reportSourceExceptionReturnIssuedUnit.Name = "ExceptionReturnIssuedUnitDataSet";
                    reportSourceExceptionReturnIssuedUnit.Value = _reportData.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionReturnIssuedUnit);
            }
            else if (e.ReportPath == "ExceptionUnitAboRh" || e.DataSourceNames[0].ToString() == "ExceptionUnitAboRhDataSet")
            {
                ReportDataSource reportSourceExceptionUnitAboRh = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitAboRh") >= 0)
                {
                    reportSourceExceptionUnitAboRh.Name = "ExceptionUnitAboRhDataSet";
                    reportSourceExceptionUnitAboRh.Value = _reportData.Tables["ExceptionReportUnitAboRh"];
                }
                e.DataSources.Add(reportSourceExceptionUnitAboRh);
            }
            else if (e.ReportPath == "ExceptionUnitModification" || e.DataSourceNames[0].ToString() == "ExceptionUnitModificationDataSet")
            {
                ReportDataSource reportSourceExceptionUnitModification = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitModification") >= 0)
                {
                    reportSourceExceptionUnitModification.Name = "ExceptionUnitModificationDataSet";
                    reportSourceExceptionUnitModification.Value = _reportData.Tables["ExceptionReportUnitModification"];
                }
                e.DataSources.Add(reportSourceExceptionUnitModification);
            }
            else if (e.ReportPath == "ExceptionUnitSelection" || e.DataSourceNames[0].ToString() == "ExceptionUnitSelectionDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSelection = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitSelection") >= 0)
                {
                    reportSourceExceptionUnitSelection.Name = "ExceptionUnitSelectionDataSet";
                    reportSourceExceptionUnitSelection.Value = _reportData.Tables["ExceptionReportUnitSelection"];
                }
                e.DataSources.Add(reportSourceExceptionUnitSelection);
            }
            else if (e.ReportPath == "ExceptionUnitSupply" || e.DataSourceNames[0].ToString() == "ExceptionUnitSupplyDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSupply = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitSupplyForBloodUnit") >= 0)
                {
                    reportSourceExceptionUnitSupply.Name = "ExceptionUnitSupplyDataSet";
                    reportSourceExceptionUnitSupply.Value = _reportData.Tables["ExceptionReportUnitSupplyForBloodUnit"];
                }
                e.DataSources.Add(reportSourceExceptionUnitSupply);
            }
            else if (e.ReportPath == "ExceptionQC" || e.DataSourceNames[0].ToString() == "ExceptionQCDataSet")
            {
                ReportDataSource reportSourceExceptionQC = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportQC") >= 0)
                {
                    reportSourceExceptionQC.Name = "ExceptionQCDataSet";
                    reportSourceExceptionQC.Value = _reportData.Tables["ExceptionReportQC"];
                }
                e.DataSources.Add(reportSourceExceptionQC);
            }
        }

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC085.FrmUnitDataReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvBloodUnitHistoryReport); 
        }

		#endregion

		#region Events

		/// <summary>
		/// Cancel_Click
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Print_Click
		/// </summary>
		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvBloodUnitHistoryReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		#endregion

        private void FrmUnitDataReport_Load(object sender, EventArgs e)
        {

            this.rvBloodUnitHistoryReport.RefreshReport();
        }
	}
}
